/*
 * -Userspace program that communicates with the span_cme peripheral
 *  primarily through ioctls
 * -program reads the portifolio data from the "input_file.txt"
 * -program outputs all the read data from the peripheral to "output_file.txt"
 *
 * Vidhatre Gathey
 * Columbia University
 */

#include <stdio.h>
#include "span_cme.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <inttypes.h>
#define NUM_OF_PORTIFOLIO 3 // number of portifolios the input contains
int span_cme_fd;

/* function to read the output from the board using an ioctl function, 
 * open an output file, and 
 * append the output data to the file 
 */
void print_output() {
    portifolio_t port;
    FILE *fpout;
    fpout = fopen("output_file.txt","a"); 
    
    if (ioctl(span_cme_fd, SPAN_CME_READ_DIGIT, &port)) {
      perror("ioctl(SPAN_CME_READ_DIGIT) failed");
      return;
    }
    	printf("%04d ", port.output);
	fprintf(fpout,"%04d ", port.output);

    printf("\n"); 
    fprintf(fpout,"\n");

    if (fpout) fclose(fpout);
}

/* Write the contents of the input portifolio data to the board, 
 * used the ioctl function to wrtie to the board
 */
void write_portifolio(short var[])
{
  portifolio_t port;
  int i;
    for (i=0; i< DATA_LENGTH; i++)
    	port.input[i] = var[i];
    port.output = 0;
    if (ioctl(span_cme_fd, SPAN_CME_WRITE_DIGIT, &port)) {
      perror("ioctl(SPAN_CME_WRITE_DIGIT) failed");
      return;
    }
}

int main()
{
  portifolio_t port;		// portifolio template as described in the header span_cme.h
  int i,j,k;			// iterators
  short var[DATA_LENGTH];       // used as a buffer for storing the data from the input file as it is read
  char label[DATA_LENGTH][14];  // store the first line of labels from the input file
  static const char filename[] = "/dev/span_cme"; 
  FILE *fpin;

  printf("SPAN CME Userspace program started\n");

  fpin=fopen("input_file.txt", "r+"); // open input file 
  
  if ( (span_cme_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;
  }
  
  for (j = NUM_OF_PORTIFOLIO ; j > 0 ; j--){   // read the a set of data i.e. a portifolio from the input file
  	for(k = 0; k < DATA_LENGTH; k++) 
  		fscanf( fpin, "%hu",&var[k]);
  	write_portifolio(var);
  	print_output();
  }
  fclose(fpin);

  printf("SPAN CME Userspace program terminating\n");
  return 0;
}
